// Listing 10-11

import java.io.*;
import java.util.Scanner;

public class Listing10_11
{
   public static void main(String[] args) throws IOException
   {
      // Zmienne, w których zapiszemy pola rekordu
      String description;
      double quantity;
      
      // Zmienna, w której zapiszemy szukaną wartość
      String searchValue;
      
      // Flaga wskazująca, czy wartość została odnaleziona
      boolean found = false;
      
      // Tworzymy obiekt Scanner, aby odczytać dane wprowadzone na klawiaturze
      Scanner keyboard = new Scanner(System.in);
      
      // Pobieramy szukaną wartość
      System.out.print("Której kawy szukasz?");
      searchValue = keyboard.nextLine();
      
      // Otwieramy plik coffee.dat
      Scanner coffeeFile = new Scanner(new File("coffee.dat"));
      
      // Wyświetlamy rekordy zapisane w pliku
      while (coffeeFile.hasNext())
      {
         // Odczytujemy rekord z pliku;
         // na początku odczytujemy nazwę kawy
         description = coffeeFile.nextLine();
         
         // Następnie odczytujemy ilość
         quantity = coffeeFile.nextDouble();
         // Odczytujemy znak końca linii...
         coffeeFile.nextLine();
         
         // Jeśli rekord zawiera szukaną wartość,
         // wyświetlamy go
         if (description.indexOf(searchValue) != -1)
         {
            System.out.println("Nazwa: " + description);
            System.out.println("Ilość: " + quantity +  " kg");
            
            // Ustawiamy flagę na true
            found = true;
         }
      }

      // Jeśli szukanej wartości nie udało się odnaleźć,
      // wyświetlamy odpowiedni komunikat
      if (!found)
         System.out.println("Nie znaleziono: " +searchValue);
         
      // Zamykamy plik
      coffeeFile.close();
   }
}